# A6 Earth-Ring Amplitude (catalog lock)
This repository contains a **self-contained stdlib-only engine** to estimate the calibration factor **alpha_P** using a thin "Earth ring" diagnostic and to verify it against a catalog value.

## How to run
```bash
python engine_a6_alpha.py \
  --manifest "/mnt/data/A6_alpha_zero_touch/20251105T150442Z/config/manifest.json" \
  --diag     "/mnt/data/A6_alpha_zero_touch/20251105T150442Z/config/diagnostics.json" \
  --out      "/mnt/data/A6_alpha_zero_touch/20251105T150442Z/outputs"
```
This will create metrics, audits, and (on PASS) a `run_info/catalog.json` record.

## Files
- `engine_a6_alpha.py` — single-file engine.
- `config/manifest.json` — engine contract (χ, catalog alpha_P, rng seed, grid).
- `config/diagnostics.json` — tolerances and geometry (annuli, ring, noise).
- `outputs/` — metrics, audits, and (if PASS) `run_info/catalog.json`.
- `logs/` — environment info, exact command, engine stdout/stderr.

## Model & checks (brief)
We simulate annular measurements of `D(r)` obeying
```
D(r) - 1  ≈  alpha_P * chi * (R_eff / r) + noise
```
Two independent estimates:
1. **Ring mean** near `r≈R_eff` → `alpha_P ≈ mean(D-1)_ring / chi`.
2. **Global slope** fit of `y = D-1` vs `x = R_eff/r` → `alpha_P ≈ slope/chi`.

PASS requires both estimates within `tau_alpha` and `R^2 ≥ r2_min`.
